/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DestroyAllEffect;
import mage.choices.Choice;
import mage.choices.ChoiceCreatureType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.players.Player;

class KindredDominanceEffect
extends OneShotEffect {
    KindredDominanceEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Choose a creature type. Destroy all creatures that aren't of the chosen type.";
    }

    private KindredDominanceEffect(KindredDominanceEffect effect) {
        super((OneShotEffect)effect);
    }

    public KindredDominanceEffect copy() {
        return new KindredDominanceEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        ChoiceCreatureType typeChoice = new ChoiceCreatureType(game, source);
        if (controller != null && controller.choose(this.outcome, (Choice)typeChoice, game)) {
            game.informPlayers(controller.getLogName() + " has chosen " + typeChoice.getChoiceKey());
            FilterCreaturePermanent filter = new FilterCreaturePermanent("All creatures not of the chosen type");
            filter.add(Predicates.not((Predicate)SubType.byDescription((String)typeChoice.getChoiceKey()).getPredicate()));
            return new DestroyAllEffect((FilterPermanent)filter).apply(game, source);
        }
        return false;
    }
}

