/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostImpl;
import mage.game.Game;
import mage.game.permanent.Permanent;

class KithkinArmorCost
extends CostImpl {
    public KithkinArmorCost() {
        this.text = "sacrifice {this}";
    }

    private KithkinArmorCost(KithkinArmorCost cost) {
        super((CostImpl)cost);
    }

    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent != null) {
            game.getState().setValue(ability.getSourceId().toString() + "attachedToPermanent", (Object)permanent.getAttachedTo());
            this.paid = permanent.sacrifice(source, game);
            if (!this.paid) {
                game.getState().setValue(ability.getSourceId().toString() + "attachedToPermanent", null);
            }
        }
        return this.paid;
    }

    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        return permanent != null && game.getPlayer(controllerId).canPaySacrificeCost(permanent, source, controllerId, game);
    }

    public KithkinArmorCost copy() {
        return new KithkinArmorCost(this);
    }
}

