/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.UUID;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.DamageEvent;
import mage.game.events.GameEvent;
import mage.target.TargetSource;

class KithkinArmorPreventionEffect
extends PreventionEffectImpl {
    private MageObjectReference mageObjectReference;

    KithkinArmorPreventionEffect() {
        super(Duration.EndOfTurn, Integer.MAX_VALUE, false);
        this.staticText = "The next time a source of your choice would deal damage to enchanted creature this turn, prevent that damage";
    }

    private KithkinArmorPreventionEffect(KithkinArmorPreventionEffect effect) {
        super((PreventionEffectImpl)effect);
        this.mageObjectReference = effect.mageObjectReference;
    }

    public KithkinArmorPreventionEffect copy() {
        return new KithkinArmorPreventionEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        TargetSource target = new TargetSource();
        target.choose(Outcome.PreventDamage, source.getControllerId(), source.getSourceId(), source, game);
        this.mageObjectReference = new MageObjectReference(target.getFirstTarget(), game);
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (super.applies(event, source, game) && event instanceof DamageEvent && event.getAmount() > 0 && !this.used) {
            UUID enchantedCreatureId = (UUID)game.getState().getValue(source.getSourceId().toString() + "attachedToPermanent");
            DamageEvent damageEvent = (DamageEvent)event;
            if (enchantedCreatureId != null && event.getTargetId().equals(enchantedCreatureId) && damageEvent.getSourceId().equals(source.getFirstTarget())) {
                this.used = true;
                this.discard();
                return true;
            }
        }
        return false;
    }
}

