/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.SacrificeTargetEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class KjeldoranGuardDelayedTriggeredAbility
extends DelayedTriggeredAbility {
    private final MageObjectReference mor;

    KjeldoranGuardDelayedTriggeredAbility(MageObjectReference mor) {
        super((Effect)new SacrificeTargetEffect(), Duration.EndOfTurn, true);
        this.mor = mor;
    }

    private KjeldoranGuardDelayedTriggeredAbility(KjeldoranGuardDelayedTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
        this.mor = ability.mor;
    }

    public KjeldoranGuardDelayedTriggeredAbility copy() {
        return new KjeldoranGuardDelayedTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanentLeaving = game.getPermanentOrLKIBattlefield(event.getTargetId());
        return permanentLeaving != null && this.mor.equals((Object)new MageObjectReference((MageObject)permanentLeaving, game));
    }

    public String getRule() {
        return "When that creature leaves the battlefield, Sacrifice {this}";
    }
}

