/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.Objects;
import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class KlothysGodOfDestinyEffect
extends OneShotEffect {
    KlothysGodOfDestinyEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile target card from a graveyard. If it was a land card, add {R} or {G}. Otherwise, you gain 2 life and {this} deals 2 damage to each opponent.";
    }

    private KlothysGodOfDestinyEffect(KlothysGodOfDestinyEffect effect) {
        super((OneShotEffect)effect);
    }

    public KlothysGodOfDestinyEffect copy() {
        return new KlothysGodOfDestinyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Card card = game.getCard(source.getFirstTarget());
        if (player == null || card == null) {
            return false;
        }
        boolean isLand = card.isLand(game);
        player.moveCards(card, Zone.EXILED, source, game);
        if (isLand) {
            Mana mana = new Mana();
            if (player.chooseUse(Outcome.PutManaInPool, "Choose a color of mana to add", null, "Red", "Green", source, game)) {
                mana.increaseRed();
            } else {
                mana.increaseGreen();
            }
            player.getManaPool().addMana(mana, game, source);
            return true;
        }
        player.gainLife(2, game, source);
        game.getOpponents(player.getId()).stream().map(arg_0 -> ((Game)game).getPlayer(arg_0)).filter(Objects::nonNull).forEach(opponent -> opponent.damage(2, source.getSourceId(), source, game));
        return true;
    }
}

