/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.ConvokedSourceCount;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.ObjectSourcePlayer;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInLibrary;

class KnightErrantOfEosEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCreatureCard("creature card with mana value less than or equal to the number of creatures that convoked this");

    KnightErrantOfEosEffect() {
        super(Outcome.Benefit);
        this.staticText = "look at the top six cards of your library. You may reveal up to two creature cards with mana value X or less from among them, where X is the number of creatures that convoked {this}. Put the revealed cards into your hand, then shuffle";
    }

    private KnightErrantOfEosEffect(KnightErrantOfEosEffect effect) {
        super((OneShotEffect)effect);
    }

    public KnightErrantOfEosEffect copy() {
        return new KnightErrantOfEosEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, 6));
        TargetCardInLibrary target = new TargetCardInLibrary(0, 2, filter);
        player.choose(Outcome.DrawCard, (Cards)cards, (TargetCard)target, source, game);
        CardsImpl toHand = new CardsImpl((Collection)target.getTargets());
        player.revealCards(source, (Cards)toHand, game);
        player.moveCards((Cards)toHand, Zone.HAND, source, game);
        player.shuffleLibrary(source, game);
        return true;
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)KnightErrantOfEosPredicate.instance);
    }

    static enum KnightErrantOfEosPredicate implements ObjectSourcePlayerPredicate<Card>
    {
        instance;


        public boolean apply(ObjectSourcePlayer<Card> input, Game game) {
            return ((Card)input.getObject()).getManaValue() <= ConvokedSourceCount.instance.calculate(game, input.getSource(), null);
        }
    }
}

