/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.discard.DiscardHandControllerEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.watchers.common.AmountOfDamageAPlayerReceivedThisTurnWatcher;

class KnollspineDragonEffect
extends OneShotEffect {
    KnollspineDragonEffect() {
        super(Outcome.Neutral);
        this.staticText = "you may discard your hand and draw cards equal to the damage dealt to target opponent this turn";
    }

    private KnollspineDragonEffect(KnollspineDragonEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player targetOpponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (controller != null) {
            AmountOfDamageAPlayerReceivedThisTurnWatcher watcher;
            new DiscardHandControllerEffect().apply(game, source);
            if (targetOpponent != null && (watcher = (AmountOfDamageAPlayerReceivedThisTurnWatcher)game.getState().getWatcher(AmountOfDamageAPlayerReceivedThisTurnWatcher.class)) != null) {
                int drawAmount = watcher.getAmountOfDamageReceivedThisTurn(targetOpponent.getId());
                controller.drawCards(drawAmount, source, game);
                return true;
            }
            game.informPlayers(controller.getLogName() + " drew no cards");
            return true;
        }
        return false;
    }

    public KnollspineDragonEffect copy() {
        return new KnollspineDragonEffect(this);
    }
}

