/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.costs.CostAdjuster;
import mage.abilities.costs.mana.VariableManaCost;
import mage.cards.Card;
import mage.cards.k.KnollspineInvocationDiscardCost;
import mage.game.Game;
import mage.players.Player;

enum KnollspineInvocationAdjuster implements CostAdjuster
{
    instance;


    public void prepareX(Ability ability, Game game) {
        Player controller = game.getPlayer(ability.getControllerId());
        if (controller == null) {
            return;
        }
        VariableManaCost costX = ability.getManaCostsToPay().stream().filter(c -> c instanceof VariableManaCost).map(c -> (VariableManaCost)c).findFirst().orElse(null);
        if (costX == null) {
            throw new IllegalArgumentException("Wrong code usage: costX lost");
        }
        KnollspineInvocationDiscardCost costDiscard = ability.getCosts().stream().filter(c -> c instanceof KnollspineInvocationDiscardCost).map(c -> (KnollspineInvocationDiscardCost)((Object)c)).findFirst().orElse(null);
        if (costDiscard == null) {
            throw new IllegalArgumentException("Wrong code usage: costDiscard lost");
        }
        if (game.inCheckPlayableState()) {
            int minManaValue = controller.getHand().getCards(game).stream().mapToInt(MageObject::getManaValue).min().orElse(0);
            int maxManaValue = controller.getHand().getCards(game).stream().mapToInt(MageObject::getManaValue).max().orElse(0);
            ability.setVariableCostsMinMax(minManaValue, maxManaValue);
        } else {
            Card card = controller.getHand().get(costDiscard.getTargets().getFirstTarget(), game);
            if (card == null) {
                throw new IllegalStateException("Wrong code usage: card to discard lost");
            }
            ability.setVariableCostsValue(card.getManaValue());
        }
    }
}

