/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostImpl;
import mage.abilities.costs.EarlyTargetCost;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInHand;

class KnollspineInvocationDiscardCost
extends CostImpl
implements EarlyTargetCost {
    public KnollspineInvocationDiscardCost() {
        this.text = "Discard a card with mana value X";
    }

    public KnollspineInvocationDiscardCost(KnollspineInvocationDiscardCost cost) {
        super((CostImpl)cost);
    }

    public KnollspineInvocationDiscardCost copy() {
        return new KnollspineInvocationDiscardCost(this);
    }

    public void chooseTarget(Game game, Ability source, Player controller) {
        TargetCardInHand target = new TargetCardInHand().withChooseHint("to discard with mana value for X");
        controller.choose(Outcome.Discard, (Target)target, source, game);
        this.addTarget((Target)target);
    }

    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        Player controller = game.getPlayer(controllerId);
        return controller != null && !controller.getHand().isEmpty();
    }

    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        this.paid = false;
        Player controller = game.getPlayer(controllerId);
        if (controller == null) {
            return false;
        }
        Card card = controller.getHand().get(this.getTargets().getFirstTarget(), game);
        if (card == null) {
            return false;
        }
        this.paid = controller.discard(card, true, source, game);
        return this.paid;
    }
}

