/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.UUID;
import mage.ApprovingObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.common.FilterNonlandCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.CardIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInExile;
import mage.util.CardUtil;

class KnowledgePoolExileAndPlayEffect
extends OneShotEffect {
    KnowledgePoolExileAndPlayEffect() {
        super(Outcome.Neutral);
        this.staticText = "Whenever a player casts a spell from their hand, that player exiles it. If the player does, they may cast another nonland card exiled with {this} without paying that card's mana cost";
    }

    private KnowledgePoolExileAndPlayEffect(KnowledgePoolExileAndPlayEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Spell spell = game.getStack().getSpell(this.getTargetPointer().getFirst(game, source));
        if (spell == null) {
            return false;
        }
        Permanent sourceObject = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (sourceObject == null) {
            return false;
        }
        Player spellController = game.getPlayer(spell.getControllerId());
        if (spellController == null) {
            return false;
        }
        UUID exileZoneId = CardUtil.getExileZoneId((Game)game, (UUID)source.getSourceId(), (int)sourceObject.getZoneChangeCounter(game));
        if (!spellController.moveCardsToExile((Card)spell, source, game, true, exileZoneId, sourceObject.getIdName())) {
            return false;
        }
        if (!spellController.chooseUse(Outcome.PlayForFree, "Cast another nonland card exiled with " + sourceObject.getLogName() + " without paying that card's mana cost?", source, game)) {
            return true;
        }
        FilterNonlandCard filter = new FilterNonlandCard("nonland card exiled with Knowledge Pool");
        filter.add(Predicates.not((Predicate)new CardIdPredicate(spell.getSourceId())));
        TargetCardInExile target = new TargetCardInExile(0, 1, (FilterCard)filter, source.getSourceId());
        target.withNotTarget(true);
        if (!spellController.choose(Outcome.PlayForFree, (Cards)game.getExile().getExileZone(exileZoneId), (TargetCard)target, source, game)) {
            return true;
        }
        Card card = game.getCard(target.getFirstTarget());
        if (card == null || card.getId().equals(spell.getSourceId())) {
            return true;
        }
        game.getState().setValue("PlayFromNotOwnHandZone" + card.getId(), (Object)Boolean.TRUE);
        spellController.cast(spellController.chooseAbilityForCast(card, game, true), game, true, new ApprovingObject(source, game));
        game.getState().setValue("PlayFromNotOwnHandZone" + card.getId(), null);
        return true;
    }

    public KnowledgePoolExileAndPlayEffect copy() {
        return new KnowledgePoolExileAndPlayEffect(this);
    }
}

