/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class KraulHarpoonerEffect
extends OneShotEffect {
    KraulHarpoonerEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose up to one target creature you don't control with flying. {this} gets +X/+0 until end of turn, where X is the number of creature cards in your graveyard, then you may have {this} fight that creature.";
    }

    private KraulHarpoonerEffect(KraulHarpoonerEffect effect) {
        super((OneShotEffect)effect);
    }

    public KraulHarpoonerEffect copy() {
        return new KraulHarpoonerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent sourcePerm = game.getPermanent(source.getSourceId());
        Player player = game.getPlayer(source.getControllerId());
        if (sourcePerm == null || player == null) {
            return false;
        }
        int xValue = player.getGraveyard().count((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game);
        game.addEffect((ContinuousEffect)new BoostSourceEffect(xValue, 0, Duration.EndOfTurn), source);
        game.processAction();
        Permanent creature = game.getPermanent(source.getFirstTarget());
        if (creature == null || !player.chooseUse(this.outcome, "Have " + sourcePerm.getLogName() + " fight " + creature.getLogName() + "?", source, game)) {
            return true;
        }
        return creature.fight(sourcePerm, source, game);
    }
}

