/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.combat.GoadTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.TrampleAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class KrosDefenseContractorEffect
extends OneShotEffect {
    KrosDefenseContractorEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "tap that creature and goad it. It gains trample until your next turn.";
    }

    private KrosDefenseContractorEffect(KrosDefenseContractorEffect effect) {
        super((OneShotEffect)effect);
    }

    public KrosDefenseContractorEffect copy() {
        return new KrosDefenseContractorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent creature = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        if (creature == null) {
            return false;
        }
        creature.tap(source, game);
        game.addEffect(new GainAbilityTargetEffect((Ability)TrampleAbility.getInstance(), Duration.UntilYourNextTurn).setTargetPointer((TargetPointer)new FixedTarget(creature, game)), source);
        game.addEffect(new GoadTargetEffect().setTargetPointer((TargetPointer)new FixedTarget(creature, game)), source);
        return true;
    }
}

