/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.k.KusariGamaDamageEffect;
import mage.constants.Zone;
import mage.filter.common.FilterBlockingCreature;
import mage.filter.common.FilterCreaturePermanent;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class KusariGamaAbility
extends TriggeredAbilityImpl {
    private static final FilterCreaturePermanent filter = new FilterBlockingCreature();

    public KusariGamaAbility() {
        super(Zone.BATTLEFIELD, (Effect)new KusariGamaDamageEffect());
    }

    private KusariGamaAbility(KusariGamaAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public KusariGamaAbility copy() {
        return new KusariGamaAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PERMANENT;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent sourcePermanet = game.getPermanent(event.getSourceId());
        Permanent targetPermanet = game.getPermanent(event.getTargetId());
        if (sourcePermanet != null && targetPermanet != null && sourcePermanet.getAttachments().contains(this.getSourceId()) && filter.match((Object)targetPermanet, game)) {
            ((Effect)this.getEffects().get(0)).setValue("damageAmount", (Object)event.getAmount());
            ((Effect)this.getEffects().get(0)).setValue("damagedCreatureId", (Object)targetPermanet.getId());
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever equipped creature deals damage to a blocking creature, {this} deals that much damage to each other creature defending player controls.";
    }
}

