/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.UUID;
import mage.ApprovingObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.k.KyloxsVoltstriderReplacementEffect;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.ExileZone;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInExile;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class KyloxsVoltstriderEffect
extends OneShotEffect {
    KyloxsVoltstriderEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may cast an instant or sorcery spell from among cards exiled with it. If that spell would be put into a graveyard, put it on the bottom of its owner's library instead.";
    }

    private KyloxsVoltstriderEffect(KyloxsVoltstriderEffect effect) {
        super((OneShotEffect)effect);
    }

    public KyloxsVoltstriderEffect copy() {
        return new KyloxsVoltstriderEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        UUID exileId = CardUtil.getExileZoneId((Game)game, (UUID)source.getSourceId(), (int)game.getState().getZoneChangeCounter(source.getSourceId()));
        ExileZone exileZone = game.getExile().getExileZone(exileId);
        if (controller == null || exileZone == null) {
            return false;
        }
        TargetCardInExile target = new TargetCardInExile((FilterCard)StaticFilters.FILTER_CARD_INSTANT_OR_SORCERY, exileId);
        target.withNotTarget(true);
        if (!target.canChoose(source.getControllerId(), source, game)) {
            return true;
        }
        controller.chooseTarget(this.outcome, (Target)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        if (card != null) {
            game.getState().setValue("PlayFromNotOwnHandZone" + card.getId(), (Object)Boolean.TRUE);
            controller.cast(controller.chooseAbilityForCast(card, game, false), game, false, new ApprovingObject(source, game));
            game.getState().setValue("PlayFromNotOwnHandZone" + card.getId(), null);
            KyloxsVoltstriderReplacementEffect effect = new KyloxsVoltstriderReplacementEffect();
            effect.setTargetPointer((TargetPointer)new FixedTarget(card, game));
            game.addEffect((ContinuousEffect)effect, source);
        }
        return true;
    }
}

