/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.ArrayList;
import java.util.Objects;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;
import mage.players.PlayerList;
import mage.target.common.TargetCardInHand;

class KynaiosAndTirosEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("a land card");

    public KynaiosAndTirosEffect() {
        super(Outcome.DrawCard);
        this.staticText = "draw a card. Each player may put a land card from their hand onto the battlefield, then each opponent who didn't draws a card";
    }

    private KynaiosAndTirosEffect(KynaiosAndTirosEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            controller.drawCards(1, source, game);
            PlayerList playerList = game.getState().getPlayerList().copy();
            while (!((UUID)playerList.get()).equals(source.getControllerId()) && controller.canRespond()) {
                playerList.getNext();
            }
            Player currentPlayer = game.getPlayer((UUID)playerList.get());
            UUID firstInactivePlayer = null;
            TargetCardInHand target = new TargetCardInHand(filter);
            ArrayList<UUID> noLandPlayers = new ArrayList<UUID>();
            while (controller.canRespond()) {
                if (currentPlayer != null && currentPlayer.canRespond() && game.getState().getPlayersInRange(controller.getId(), game).contains((Object)currentPlayer.getId())) {
                    Card card;
                    if (firstInactivePlayer == null) {
                        firstInactivePlayer = currentPlayer.getId();
                    }
                    target.clearChosen();
                    boolean playedLand = false;
                    if (target.canChoose(currentPlayer.getId(), source, game) && currentPlayer.chooseUse(this.outcome, "Put a land card from your hand onto the battlefield?", source, game) && target.chooseTarget(this.outcome, currentPlayer.getId(), source, game) && (card = game.getCard(target.getFirstTarget())) != null) {
                        currentPlayer.moveCards(card, Zone.BATTLEFIELD, source, game);
                        playedLand = true;
                    }
                    if (!playedLand && !Objects.equals(currentPlayer, controller)) {
                        noLandPlayers.add(currentPlayer.getId());
                    }
                }
                playerList.getNext();
                currentPlayer = game.getPlayer((UUID)playerList.get());
                if (!currentPlayer.getId().equals(firstInactivePlayer)) continue;
            }
            for (UUID playerId : noLandPlayers) {
                Player player = game.getPlayer(playerId);
                if (player == null) continue;
                player.drawCards(1, source, game);
            }
            return true;
        }
        return false;
    }

    public KynaiosAndTirosEffect copy() {
        return new KynaiosAndTirosEffect(this);
    }

    static {
        filter.add((Predicate)CardType.LAND.getPredicate());
    }
}

