/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.RemoveVariableCountersSourceCost;
import mage.abilities.costs.common.TapSourceCost;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.abilities.effects.mana.ManaEffect;
import mage.abilities.mana.SimpleManaAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

public final class KyrenToy
extends CardImpl {
    public KyrenToy(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ARTIFACT}, "{3}");
        SimpleActivatedAbility ability = new SimpleActivatedAbility((Effect)new AddCountersSourceEffect(CounterType.CHARGE.createInstance(1)), (Cost)new GenericManaCost(1));
        ability.addCost((Cost)new TapSourceCost());
        this.addAbility((Ability)ability);
        ability = new SimpleManaAbility(Zone.BATTLEFIELD, (ManaEffect)new KyrenToyManaEffect(), (Cost)new TapSourceCost());
        ability.addCost((Cost)new RemoveVariableCountersSourceCost(CounterType.CHARGE));
        this.addAbility((Ability)ability);
    }

    private KyrenToy(KyrenToy card) {
        super((CardImpl)card);
    }

    public KyrenToy copy() {
        return new KyrenToy(this);
    }

    private static class KyrenToyManaEffect
    extends ManaEffect {
        private KyrenToyManaEffect() {
            this.staticText = "Add an amount of {C} equal to X plus one";
        }

        private KyrenToyManaEffect(KyrenToyManaEffect effect) {
            super((ManaEffect)effect);
        }

        public List<Mana> getNetMana(Game game, Ability source) {
            Permanent sourceObject;
            ArrayList<Mana> netMana = new ArrayList<Mana>();
            if (game != null && (sourceObject = game.getPermanent(source.getSourceId())) != null) {
                netMana.add(Mana.ColorlessMana((int)(sourceObject.getCounters(game).getCount(CounterType.CHARGE) + 1)));
                return netMana;
            }
            return netMana;
        }

        public Mana produceMana(Game game, Ability source) {
            Mana mana = new Mana();
            if (game == null) {
                return mana;
            }
            Player player = game.getPlayer(source.getControllerId());
            if (player == null) {
                return mana;
            }
            int numberOfMana = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
            return Mana.ColorlessMana((int)(numberOfMana + 1));
        }

        public KyrenToyManaEffect copy() {
            return new KyrenToyManaEffect(this);
        }
    }
}

