/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class DeathEffect
extends OneShotEffect {
    DeathEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "return target creature card from your graveyard to the battlefield. You lose life equal to its mana value";
    }

    private DeathEffect(DeathEffect effect) {
        super((OneShotEffect)effect);
    }

    public DeathEffect copy() {
        return new DeathEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card creatureCard = game.getCard(this.getTargetPointer().getFirst(game, source));
        Player controller = game.getPlayer(source.getControllerId());
        if (creatureCard != null && controller != null) {
            boolean result = false;
            if (game.getState().getZone(creatureCard.getId()) == Zone.GRAVEYARD) {
                controller.moveCards(creatureCard, Zone.BATTLEFIELD, source, game);
            }
            controller.loseLife(creatureCard.getManaValue(), game, source, false);
            return true;
        }
        return false;
    }
}

