/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

class LaboratoryDrudgeWatcher
extends Watcher {
    private final Set<UUID> playerSet = new HashSet<UUID>();

    LaboratoryDrudgeWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getZone() != Zone.GRAVEYARD) {
            return;
        }
        switch (event.getType()) {
            case SPELL_CAST: 
            case ACTIVATED_ABILITY: {
                this.playerSet.add(event.getPlayerId());
            }
        }
    }

    public void reset() {
        this.playerSet.clear();
        super.reset();
    }

    boolean checkPlayer(UUID playerId) {
        return this.playerSet.contains(playerId);
    }
}

