/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.SacrificeEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.BlockingAttackerIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class LabyrinthRaptorEffect
extends OneShotEffect {
    LabyrinthRaptorEffect() {
        super(Outcome.Benefit);
        this.staticText = "defending player sacrifices a creature blocking it";
    }

    private LabyrinthRaptorEffect(LabyrinthRaptorEffect effect) {
        super((OneShotEffect)effect);
    }

    public LabyrinthRaptorEffect copy() {
        return new LabyrinthRaptorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        if (permanent == null) {
            return false;
        }
        Player player = game.getPlayer(game.getCombat().getDefendingPlayerId(permanent.getId(), game));
        if (player == null) {
            return false;
        }
        FilterPermanent filterPermanent = new FilterPermanent("creature blocking " + permanent.getIdName());
        filterPermanent.add((Predicate)new BlockingAttackerIdPredicate(permanent.getId()));
        SacrificeEffect effect = new SacrificeEffect(filterPermanent, 1, "");
        effect.setTargetPointer((TargetPointer)new FixedTarget(player.getId(), game));
        return effect.apply(game, source);
    }
}

