/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.Collection;
import java.util.Iterator;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.ExileReturnBattlefieldNextEndStepTargetEffect;
import mage.abilities.effects.common.InfoEffect;
import mage.abilities.effects.common.ReturnToBattlefieldUnderOwnerControlTargetEffect;
import mage.abilities.effects.common.RollDieWithResultTableEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.PutCards;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.TokenPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;

class LaezelsAcrobaticsEffect
extends RollDieWithResultTableEffect {
    private static final FilterControlledCreaturePermanent creatureFilter = new FilterControlledCreaturePermanent();

    LaezelsAcrobaticsEffect() {
        super(20, "Exile all nontoken creatures you control, then roll a d20");
        this.addTableEntry(1, 9, new Effect[]{new InfoEffect("Return those cards to the battlefield under their owner's control at the beginning of the next end step.")});
        this.addTableEntry(10, 20, new Effect[]{new InfoEffect("Return those cards to the battlefield under their owner's control, then exile them again. Return those cards to the battlefield under their owner's control at the beginning of the next end step.")});
    }

    private LaezelsAcrobaticsEffect(LaezelsAcrobaticsEffect effect) {
        super((RollDieWithResultTableEffect)effect);
    }

    public LaezelsAcrobaticsEffect copy() {
        return new LaezelsAcrobaticsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CardsImpl toFlicker = new CardsImpl(game.getBattlefield().getActivePermanents((FilterPermanent)creatureFilter, controller.getId(), game));
        controller.moveCards((Cards)toFlicker, Zone.EXILED, source, game);
        game.processAction();
        int result = controller.rollDice(this.outcome, source, game, 20);
        if (result >= 1 && result <= 9) {
            ReturnToBattlefieldUnderOwnerControlTargetEffect effect = new ReturnToBattlefieldUnderOwnerControlTargetEffect(false, false);
            effect.setTargetPointer((TargetPointer)new FixedTargets((Cards)new CardsImpl((Collection)toFlicker), game));
            game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)effect), source);
        } else if (result >= 10 && result <= 20) {
            for (UUID cardId : toFlicker) {
                Card card = game.getCard(cardId);
                if (card == null) continue;
                PutCards.BATTLEFIELD.moveCard(game.getPlayer(card.getOwnerId()), card.getMainCard(), source, game, "card");
            }
            game.processAction();
            Iterator effect = new ExileReturnBattlefieldNextEndStepTargetEffect();
            effect.setTargetPointer((TargetPointer)new FixedTargets((Cards)toFlicker, game));
            effect.apply(game, source);
        }
        return true;
    }

    static {
        creatureFilter.add((Predicate)TokenPredicate.FALSE);
    }
}

