/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.SacrificeTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.Elemental21TrampleHasteToken;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class LagomosHandOfHatredEffect
extends OneShotEffect {
    LagomosHandOfHatredEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "create a 2/1 red Elemental creature token with trample and haste. Sacrifice it at the beginning of the next end step.";
    }

    private LagomosHandOfHatredEffect(LagomosHandOfHatredEffect effect) {
        super((OneShotEffect)effect);
    }

    public LagomosHandOfHatredEffect copy() {
        return new LagomosHandOfHatredEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Elemental21TrampleHasteToken token = new Elemental21TrampleHasteToken();
        token.putOntoBattlefield(1, game, source);
        for (UUID tokenId : token.getLastAddedTokenIds()) {
            Permanent permanent = game.getPermanent(tokenId);
            if (permanent == null) continue;
            game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)new SacrificeTargetEffect("sacrifice it").setTargetPointer((TargetPointer)new FixedTarget(permanent, game))), source);
        }
        return true;
    }
}

