/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class LagonnaBandStorytellerEffect
extends OneShotEffect {
    LagonnaBandStorytellerEffect() {
        super(Outcome.Benefit);
        this.staticText = "put target enchantment card from your graveyard on top of your library. If you do, you gain life equal to its mana value.";
    }

    private LagonnaBandStorytellerEffect(LagonnaBandStorytellerEffect effect) {
        super((OneShotEffect)effect);
    }

    public LagonnaBandStorytellerEffect copy() {
        return new LagonnaBandStorytellerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Card card = game.getCard(source.getFirstTarget());
        if (controller == null || card == null || !card.isEnchantment(game) || game.getState().getZone(card.getId()) != Zone.GRAVEYARD) {
            return false;
        }
        int cmc = card.getManaValue();
        if (controller.putCardsOnTopOfLibrary((Cards)new CardsImpl(card), game, source, false)) {
            controller.gainLife(cmc, game, source);
            return true;
        }
        return false;
    }
}

