/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.HashSet;
import java.util.Set;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.cards.Cards;
import mage.constants.Duration;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class LagrellaTheMagpieTriggeredAbility
extends DelayedTriggeredAbility {
    private final Set<MageObjectReference> morSet = new HashSet<MageObjectReference>();

    LagrellaTheMagpieTriggeredAbility(Cards cards, Game game) {
        super((Effect)new AddCountersTargetEffect(CounterType.P1P1.createInstance(2)), Duration.Custom, false, false);
        cards.getCards(game).stream().map(card -> new MageObjectReference((MageObject)card, game, 1)).forEach(this.morSet::add);
    }

    private LagrellaTheMagpieTriggeredAbility(LagrellaTheMagpieTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
        this.morSet.addAll(ability.morSet);
    }

    public LagrellaTheMagpieTriggeredAbility copy() {
        return new LagrellaTheMagpieTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent = ((EntersTheBattlefieldEvent)event).getTarget();
        if (permanent.isControlledBy(this.getControllerId()) && this.morSet.stream().anyMatch(mor -> mor.refersTo((MageObject)permanent, game))) {
            this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
            return true;
        }
        return false;
    }

    public String getRule() {
        return "When an exiled card you control enters this way, put two +1/+1 counters on it.";
    }
}

