/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class LammastideWeaveEffect
extends OneShotEffect {
    LammastideWeaveEffect() {
        super(Outcome.DrawCard);
        this.staticText = ", then target player mills a card. If a card with the chosen name was milled this way, you gain life equal to its mana value.";
    }

    private LammastideWeaveEffect(LammastideWeaveEffect effect) {
        super((OneShotEffect)effect);
    }

    public LammastideWeaveEffect copy() {
        return new LammastideWeaveEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player targetPlayer = game.getPlayer(source.getFirstTarget());
        String cardName = (String)game.getState().getValue(source.getSourceId().toString() + "NAMED_CARD");
        if (controller == null || targetPlayer == null || cardName == null || cardName.isEmpty()) {
            return false;
        }
        for (Card card : targetPlayer.millCards(1, source, game).getCards(game)) {
            if (!CardUtil.haveSameNames((MageObject)card, (String)cardName, (Game)game)) continue;
            controller.gainLife(card.getManaValue(), game, source);
        }
        return true;
    }
}

