/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.players.Player;

class LaraCroftTombRaiderExileEffect
extends OneShotEffect {
    LaraCroftTombRaiderExileEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile up to one target legendary artifact card or legendary land card from a graveyard and put a discovery counter on it";
    }

    private LaraCroftTombRaiderExileEffect(LaraCroftTombRaiderExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public LaraCroftTombRaiderExileEffect copy() {
        return new LaraCroftTombRaiderExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (player == null || card == null) {
            return false;
        }
        player.moveCards(card, Zone.EXILED, source, game);
        card.addCounters(CounterType.DISCOVERY.createInstance(), source, game);
        return true;
    }
}

