/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.List;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.OneShotEffect;
import mage.cards.l.LastNightTogetherDelayedCantAttackAbility;
import mage.constants.Outcome;
import mage.constants.TurnPhase;
import mage.game.Game;
import mage.game.turn.TurnMod;
import mage.target.Target;

class LastNightTogetherEffect
extends OneShotEffect {
    LastNightTogetherEffect() {
        super(Outcome.Benefit);
        this.staticText = "After this main phase, there is an additional combat phase. Only the chosen creatures can attack during that combat phase";
    }

    private LastNightTogetherEffect(LastNightTogetherEffect effect) {
        super((OneShotEffect)effect);
    }

    public LastNightTogetherEffect copy() {
        return new LastNightTogetherEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        if (game.getTurnPhaseType().isMain()) {
            TurnMod combat = new TurnMod(game.getState().getActivePlayerId()).withExtraPhase(TurnPhase.COMBAT);
            game.getState().getTurnMods().add(combat);
            List targets = ((Target)source.getTargets().get(0)).getTargets();
            LastNightTogetherDelayedCantAttackAbility delayedTriggeredAbility = new LastNightTogetherDelayedCantAttackAbility(targets, game, combat.getId());
            game.addDelayedTriggeredAbility((DelayedTriggeredAbility)delayedTriggeredAbility, source);
            return true;
        }
        return true;
    }
}

