/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.List;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.watchers.common.PermanentsEnteredBattlefieldWatcher;

enum LavaballTrapCondition implements Condition
{
    instance;


    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        PermanentsEnteredBattlefieldWatcher watcher = (PermanentsEnteredBattlefieldWatcher)game.getState().getWatcher(PermanentsEnteredBattlefieldWatcher.class);
        if (watcher != null && controller != null) {
            for (UUID opponentId : game.getOpponents(controller.getId())) {
                List permanents = watcher.getThisTurnEnteringPermanents(opponentId);
                if (permanents == null) continue;
                int count = 0;
                for (Permanent permanent : permanents) {
                    if (!permanent.isLand(game) || ++count != 2) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public String toString() {
        return "an opponent had two or more lands enter the battlefield under their control this turn";
    }
}

