/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.Arrays;
import java.util.HashSet;
import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DamageAllEffect;
import mage.choices.Choice;
import mage.choices.ChoiceImpl;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class LavabrinkFloodgatesEffect
extends OneShotEffect {
    LavabrinkFloodgatesEffect() {
        super(Outcome.Benefit);
        this.staticText = "that player may put a doom counter on {this} or remove a doom counter from it. Then if it has three or more doom counters on it, sacrifice {this}. When you do, it deals 6 damage to each creature.";
    }

    private LavabrinkFloodgatesEffect(LavabrinkFloodgatesEffect effect) {
        super((OneShotEffect)effect);
    }

    public LavabrinkFloodgatesEffect copy() {
        return new LavabrinkFloodgatesEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(game.getActivePlayerId());
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (player == null || permanent == null) {
            return false;
        }
        ChoiceImpl choice = new ChoiceImpl(false);
        choice.setChoices(new HashSet<String>(Arrays.asList("Add a doom counter", "Remove a doom counter", "Do nothing")));
        player.choose(this.outcome, (Choice)choice, game);
        switch (choice.getChoice()) {
            case "Add a doom counter": {
                permanent.addCounters(CounterType.DOOM.createInstance(), player.getId(), source, game);
                break;
            }
            case "Remove a doom counter": {
                permanent.removeCounters(CounterType.DOOM.createInstance(), source, game);
                break;
            }
        }
        if (permanent.getCounters(game).getCount(CounterType.DOOM) < 3 || !permanent.sacrifice(source, game)) {
            return true;
        }
        game.fireReflexiveTriggeredAbility(new ReflexiveTriggeredAbility((Effect)new DamageAllEffect(6, (FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE), false, "it deals 6 damage to each creature."), source);
        return true;
    }
}

