/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.effects.common.continuous.GainAbilitySourceEffect;
import mage.abilities.keyword.ProtectionAbility;
import mage.constants.ModeChoice;
import mage.filter.Filter;
import mage.filter.FilterObject;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValueParityPredicate;
import mage.game.Game;

class LavabrinkVenturerEffect
extends GainAbilitySourceEffect {
    private static final FilterObject nullFilter = new FilterObject("nothing");
    private static final FilterObject oddFilter = new FilterObject("odd mana values");
    private static final FilterObject evenFilter = new FilterObject("even mana values");

    LavabrinkVenturerEffect() {
        super((Ability)new ProtectionAbility((Filter)nullFilter));
        this.ability.setRuleVisible(false);
        this.staticText = "{this} has protection from each mana value of the chosen quality. <i>(Zero is even.)</i>";
    }

    private LavabrinkVenturerEffect(LavabrinkVenturerEffect effect) {
        super((GainAbilitySourceEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        if (ModeChoice.ODD.checkMode(game, source)) {
            this.ability = new ProtectionAbility((Filter)oddFilter);
        } else if (ModeChoice.EVEN.checkMode(game, source)) {
            this.ability = new ProtectionAbility((Filter)evenFilter);
        } else {
            return false;
        }
        return super.apply(game, source);
    }

    public LavabrinkVenturerEffect copy() {
        return new LavabrinkVenturerEffect(this);
    }

    static {
        nullFilter.add((Predicate)ManaValueParityPredicate.ODD);
        nullFilter.add((Predicate)ManaValueParityPredicate.EVEN);
        oddFilter.add((Predicate)ManaValueParityPredicate.ODD);
        evenFilter.add((Predicate)ManaValueParityPredicate.EVEN);
    }
}

