/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CopyEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetCard;
import mage.util.CardUtil;

class LazavWearerOfFacesEffect
extends OneShotEffect {
    LazavWearerOfFacesEffect() {
        super(Outcome.Copy);
        this.staticText = "you may have {this} become a copy of a creature card exiled with it until end of turn";
    }

    private LazavWearerOfFacesEffect(LazavWearerOfFacesEffect effect) {
        super((OneShotEffect)effect);
    }

    public LazavWearerOfFacesEffect copy() {
        return new LazavWearerOfFacesEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent lazav = game.getPermanent(source.getSourceId());
        if (controller == null || lazav == null) {
            return false;
        }
        if (!controller.chooseUse(this.outcome, "Have {this} become a copy of a creature card exiled with it", source, game)) {
            return false;
        }
        UUID exileId = CardUtil.getExileZoneId((Game)game, (UUID)source.getSourceId(), (int)source.getStackMomentSourceZCC());
        ExileZone exile = game.getExile().getExileZone(exileId);
        if (exile == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(exile.getCards((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game));
        TargetCard target = new TargetCard(Zone.EXILED, new FilterCard("creature card to copy"));
        target.withNotTarget(true);
        controller.chooseTarget(this.outcome, (Cards)cards, target, source, game);
        Card copyFromCard = game.getCard(target.getFirstTarget());
        if (copyFromCard == null) {
            return false;
        }
        CopyEffect copyEffect = new CopyEffect(Duration.EndOfTurn, (MageObject)copyFromCard, lazav.getId());
        copyEffect.newId();
        game.addEffect((ContinuousEffect)copyEffect, source);
        return true;
    }
}

