/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class LazotepQuarryTargetEffect
extends OneShotEffect {
    LazotepQuarryTargetEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Exile target creature card with mana value X from your graveyard. Create a token that's a copy of it, except it's a 4/4 black Zombie";
    }

    private LazotepQuarryTargetEffect(LazotepQuarryTargetEffect effect) {
        super((OneShotEffect)effect);
    }

    public LazotepQuarryTargetEffect copy() {
        return new LazotepQuarryTargetEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        Player controller = game.getPlayer(source.getControllerId());
        if (card == null || controller == null) {
            return false;
        }
        controller.moveCards(card, Zone.EXILED, source, game);
        CreateTokenCopyTargetEffect effect = new CreateTokenCopyTargetEffect(source.getControllerId(), null, false, 1, false, false, null, 4, 4, false);
        effect.setTargetPointer((TargetPointer)new FixedTarget(card, game));
        effect.setOnlySubType(SubType.ZOMBIE);
        effect.setOnlyColor(ObjectColor.BLACK);
        effect.apply(game, source);
        return true;
    }
}

