/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.CardsImpl;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class LegacyOfTheBelovedEffect
extends OneShotEffect {
    private static final FilterCreatureCard filter = new FilterCreatureCard("up to two creatures cards that each have a lower mana value that sacrificied creature's mana value");

    public LegacyOfTheBelovedEffect() {
        super(Outcome.DrawCard);
        this.staticText = "Search you library for up to two creatures cards that each have a lower mana value that sacrificied creature's mana value, reveal them and put them onto the battlefield, then shuffle you library";
    }

    private LegacyOfTheBelovedEffect(LegacyOfTheBelovedEffect effect) {
        super((OneShotEffect)effect);
    }

    public LegacyOfTheBelovedEffect copy() {
        return new LegacyOfTheBelovedEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card sourceCard = game.getCard(source.getSourceId());
        if (sourceCard != null) {
            for (Cost cost : source.getCosts()) {
                Permanent p;
                if (!(cost instanceof SacrificeTargetCost) || (p = (Permanent)game.getLastKnownInformation(((Permanent)((SacrificeTargetCost)cost).getPermanents().get(0)).getId(), Zone.BATTLEFIELD)) == null) continue;
                filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, p.getManaValue()));
                TargetCardInLibrary target = new TargetCardInLibrary(0, 2, (FilterCard)filter);
                Player player = game.getPlayer(source.getControllerId());
                if (player == null || !player.searchLibrary(target, source, game)) continue;
                player.moveCards(new CardsImpl((Collection)target.getTargets()).getCards(game), Zone.BATTLEFIELD, source, game, false, false, false, null);
                player.shuffleLibrary(source, game);
                return true;
            }
        }
        return false;
    }
}

