/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityControlledEffect;
import mage.abilities.keyword.IndestructibleAbility;
import mage.constants.ComparisonType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.PowerPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class LenaSelflessChampionEffect
extends OneShotEffect {
    LenaSelflessChampionEffect() {
        super(Outcome.Benefit);
        this.staticText = "Creatures you control with power less than {this}'s power gain indestructible until end of turn";
    }

    private LenaSelflessChampionEffect(LenaSelflessChampionEffect effect) {
        super((OneShotEffect)effect);
    }

    public LenaSelflessChampionEffect copy() {
        return new LenaSelflessChampionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (permanent == null) {
            return false;
        }
        FilterCreaturePermanent filter = new FilterCreaturePermanent();
        filter.add((Predicate)new PowerPredicate(ComparisonType.FEWER_THAN, permanent.getPower().getValue()));
        game.addEffect((ContinuousEffect)new GainAbilityControlledEffect((Ability)IndestructibleAbility.getInstance(), Duration.EndOfTurn, (FilterPermanent)filter), source);
        return true;
    }
}

