/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.abilities.keyword.FlyingAbility;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class LeonardoDaVinciEffect
extends OneShotEffect {
    LeonardoDaVinciEffect() {
        super(Outcome.Benefit);
        this.staticText = "Draw a card, then discard a card. If the discarded card was an artifact card, exile it from your graveyard. If you do, create a token that's a copy of it, except it's a 0/2 Thopter artifact creature with flying in addition to its other types.";
    }

    protected LeonardoDaVinciEffect(LeonardoDaVinciEffect effect) {
        super((OneShotEffect)effect);
    }

    public LeonardoDaVinciEffect copy() {
        return new LeonardoDaVinciEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        player.drawCards(1, source, game);
        Card card = player.discardOne(false, false, source, game);
        if (card.isArtifact(game)) {
            player.moveCards(card, Zone.EXILED, source, game);
            new CreateTokenCopyTargetEffect().setPermanentModifier(token -> {
                token.addCardType(new CardType[]{CardType.CREATURE});
                token.addSubType(new SubType[]{SubType.THOPTER});
                token.addCardType(new CardType[]{CardType.ARTIFACT});
                token.setPower(0);
                token.setToughness(2);
                token.addAbility((Ability)FlyingAbility.getInstance());
            }).setTargetPointer((TargetPointer)new FixedTarget(card, game)).apply(game, source);
        }
        return true;
    }
}

