/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.OneShotEffect;
import mage.cards.l.LeoriSparktouchedHunterTriggeredAbility;
import mage.choices.Choice;
import mage.choices.ChoicePlaneswalkerType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.players.Player;

class LeoriSparktouchedHunterEffect
extends OneShotEffect {
    LeoriSparktouchedHunterEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose a planeswalker type. Until end of turn, whenever you activate an ability of a planeswalker of that type, copy that ability. You may choose new targets for the copies.";
    }

    private LeoriSparktouchedHunterEffect(LeoriSparktouchedHunterEffect effect) {
        super((OneShotEffect)effect);
    }

    public LeoriSparktouchedHunterEffect copy() {
        return new LeoriSparktouchedHunterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        ChoicePlaneswalkerType choice = new ChoicePlaneswalkerType(game.getObject(source));
        if (!controller.choose(this.outcome, (Choice)choice, game)) {
            return false;
        }
        SubType subType = SubType.byDescription((String)choice.getChoice());
        if (subType == null) {
            return false;
        }
        game.informPlayers(controller.getLogName() + " has chosen " + subType);
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new LeoriSparktouchedHunterTriggeredAbility(subType), source);
        return true;
    }
}

