/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CopyStackObjectEffect;
import mage.abilities.hint.Hint;
import mage.abilities.hint.StaticHint;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.StackAbility;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class LeoriSparktouchedHunterTriggeredAbility
extends DelayedTriggeredAbility {
    private final SubType subType;

    LeoriSparktouchedHunterTriggeredAbility(SubType subType) {
        super((Effect)new CopyStackObjectEffect(), Duration.EndOfTurn, false);
        this.subType = subType;
        this.addHint((Hint)new StaticHint("Chosen Subtype: " + subType));
        this.setTriggerPhrase("Whenever you activate an ability of a planeswalker of the chosen type, ");
    }

    private LeoriSparktouchedHunterTriggeredAbility(LeoriSparktouchedHunterTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
        this.subType = ability.subType;
    }

    public LeoriSparktouchedHunterTriggeredAbility copy() {
        return new LeoriSparktouchedHunterTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ACTIVATED_ABILITY;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!this.isControlledBy(event.getPlayerId())) {
            return false;
        }
        StackAbility stackAbility = (StackAbility)game.getStack().getStackObject(event.getSourceId());
        if (stackAbility == null || stackAbility.getStackAbility().isManaActivatedAbility()) {
            return false;
        }
        Permanent permanent = game.getPermanentOrLKIBattlefield(stackAbility.getSourceId());
        if (permanent == null || !permanent.isPlaneswalker(game) || !permanent.hasSubtype(this.subType, game)) {
            return false;
        }
        this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(event.getTargetId(), game));
        return true;
    }
}

