/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetAnyTarget;

class LeylineTyrantDamageEffect
extends OneShotEffect {
    LeylineTyrantDamageEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may pay any amount of {R}. When you do, it deals that much damage to any target";
    }

    private LeylineTyrantDamageEffect(LeylineTyrantDamageEffect effect) {
        super((OneShotEffect)effect);
    }

    public LeylineTyrantDamageEffect copy() {
        return new LeylineTyrantDamageEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        String manaString;
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int costX = player.announceX(0, Integer.MAX_VALUE, "Announce the value for {X}", game, source, true);
        if (costX == 0) {
            manaString = "{0}";
        } else {
            manaString = "";
            for (int i = 0; i < costX; ++i) {
                manaString = manaString + "{R}";
            }
        }
        ManaCostsImpl cost = new ManaCostsImpl(manaString);
        cost.clearPaid();
        if (!cost.pay(source, game, source, source.getControllerId(), false)) {
            return false;
        }
        ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new DamageTargetEffect(costX), false, "{this} deals " + costX + " damage to any target");
        ability.addTarget((Target)new TargetAnyTarget());
        game.fireReflexiveTriggeredAbility(ability, source);
        return true;
    }
}

