/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.Arrays;
import java.util.Collection;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.card.AuraCardCanAttachToPermanentId;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.BirdToken;
import mage.game.permanent.token.CatToken2;
import mage.game.permanent.token.OxToken;
import mage.players.Player;
import mage.target.TargetCard;

class LiberatedLivestockEffect
extends OneShotEffect {
    LiberatedLivestockEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "create a 1/1 white Cat creature token with lifelink, a 1/1 white Bird creature token with flying, and a 2/4 white Ox creature token. For each of those tokens, you may put an Aura card from your hand and/or graveyard onto the battlefield attached to it.";
    }

    private LiberatedLivestockEffect(LiberatedLivestockEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CatToken2 firstToken = new CatToken2();
        firstToken.putOntoBattlefield(1, game, source, source.getControllerId(), false, false, null, null, true, Arrays.asList(firstToken, new BirdToken(), new OxToken()));
        game.processAction();
        for (UUID tokenId : firstToken.getLastAddedTokenIds()) {
            Permanent tokenPermanent = game.getPermanent(tokenId);
            if (tokenPermanent == null) continue;
            FilterCard filter = new FilterCard("Aura from your hand or graveyard that can attach to " + tokenPermanent.getName());
            filter.add((Predicate)SubType.AURA.getPredicate());
            filter.add((Predicate)new AuraCardCanAttachToPermanentId(tokenPermanent.getId()));
            CardsImpl auraCards = new CardsImpl();
            auraCards.addAllCards((Collection)controller.getHand().getCards(filter, source.getControllerId(), source, game));
            auraCards.addAllCards((Collection)controller.getGraveyard().getCards(filter, source.getControllerId(), source, game));
            if (auraCards.isEmpty()) continue;
            TargetCard target = new TargetCard(0, 1, Zone.ALL, filter);
            target.withNotTarget(true);
            controller.chooseTarget(this.outcome, (Cards)auraCards, target, source, game);
            Card auraCard = game.getCard(target.getFirstTarget());
            if (auraCard == null || tokenPermanent.cantBeAttachedBy((MageObject)auraCard, source, game, true)) continue;
            game.getState().setValue("attachTo:" + auraCard.getId(), (Object)tokenPermanent);
            controller.moveCards(auraCard, Zone.BATTLEFIELD, source, game);
            tokenPermanent.addAttachment(auraCard.getId(), source, game);
        }
        return true;
    }

    public LiberatedLivestockEffect copy() {
        return new LiberatedLivestockEffect(this);
    }
}

