/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.Iterator;
import java.util.UUID;
import mage.MageObjectReference;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.CardType;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class LiegeOfTheTangleEffect
extends ContinuousEffectImpl {
    LiegeOfTheTangleEffect() {
        super(Duration.EndOfGame, Outcome.BecomeCreature);
        this.staticText = "each of those lands is an 8/8 green Elemental creature for as long as it has an awakening counter on it. They're still lands";
        this.dependencyTypes.add(DependencyType.BecomeCreature);
    }

    private LiegeOfTheTangleEffect(LiegeOfTheTangleEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Iterator it = this.affectedObjectList.iterator();
        while (it.hasNext()) {
            Permanent perm = ((MageObjectReference)it.next()).getPermanent(game);
            if (perm == null) {
                it.remove();
                continue;
            }
            if (perm.getCounters(game).getCount(CounterType.AWAKENING) < 1) continue;
            switch (layer) {
                case TypeChangingEffects_4: {
                    perm.addCardType(game, new CardType[]{CardType.CREATURE});
                    perm.addSubType(game, new SubType[]{SubType.ELEMENTAL});
                    break;
                }
                case ColorChangingEffects_5: {
                    perm.getColor(game).addColor(ObjectColor.GREEN);
                    break;
                }
                case PTChangingEffects_7: {
                    if (sublayer != SubLayer.SetPT_7b) break;
                    perm.getPower().setModifiedBaseValue(8);
                    perm.getToughness().setModifiedBaseValue(8);
                }
            }
        }
        return true;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        if (this.getAffectedObjectsSet()) {
            for (UUID permId : this.getTargetPointer().getTargets(game, source)) {
                this.affectedObjectList.add(new MageObjectReference(permId, game));
            }
        }
    }

    public LiegeOfTheTangleEffect copy() {
        return new LiegeOfTheTangleEffect(this);
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.PTChangingEffects_7 || layer == Layer.ColorChangingEffects_5 || layer == Layer.TypeChangingEffects_4;
    }
}

