/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.FlashbackAbility;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class LierDiscipleOfTheDrownedFlashbackEffect
extends ContinuousEffectImpl {
    LierDiscipleOfTheDrownedFlashbackEffect() {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "Each instant and sorcery card in your graveyard has flashback. The flashback cost is equal to that card's mana cost";
    }

    private LierDiscipleOfTheDrownedFlashbackEffect(LierDiscipleOfTheDrownedFlashbackEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public LierDiscipleOfTheDrownedFlashbackEffect copy() {
        return new LierDiscipleOfTheDrownedFlashbackEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        for (Card card : player.getGraveyard().getCards((FilterCard)StaticFilters.FILTER_CARD_INSTANT_OR_SORCERY, game)) {
            FlashbackAbility ability = new FlashbackAbility(card, (Cost)card.getManaCost());
            ability.setSourceId(card.getId());
            ability.setControllerId(card.getOwnerId());
            game.getState().addOtherAbility(card, (Ability)ability);
        }
        return true;
    }
}

