/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.HashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.abilities.effects.common.combat.GoadTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;

class LifeOfThePartyEffect
extends OneShotEffect {
    LifeOfThePartyEffect() {
        super(Outcome.Benefit);
        this.staticText = "each opponent creates a token that's a copy of it. The tokens are goaded for the rest of the game";
    }

    private LifeOfThePartyEffect(LifeOfThePartyEffect effect) {
        super((OneShotEffect)effect);
    }

    public LifeOfThePartyEffect copy() {
        return new LifeOfThePartyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = (Permanent)this.getValue("permanentEnteredBattlefield");
        if (permanent == null) {
            return false;
        }
        HashSet permanents = new HashSet();
        for (UUID playerId : game.getOpponents(source.getControllerId())) {
            CreateTokenCopyTargetEffect effect = new CreateTokenCopyTargetEffect(playerId);
            effect.setSavedPermanent(permanent);
            effect.apply(game, source);
            permanents.addAll(effect.getAddedPermanents());
        }
        if (permanents.isEmpty()) {
            return false;
        }
        game.addEffect(new GoadTargetEffect(Duration.EndOfGame).setTargetPointer((TargetPointer)new FixedTargets(permanents, game)), source);
        return true;
    }
}

