/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BecomesCreatureTargetEffect;
import mage.cards.l.LifecraftAwakeningToken;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.Token;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class LifecraftAwakeningEffect
extends OneShotEffect {
    LifecraftAwakeningEffect() {
        super(Outcome.BecomeCreature);
        this.staticText = "If it isn't a creature or Vehicle, it becomes a 0/0 Construct artifact creature";
    }

    private LifecraftAwakeningEffect(LifecraftAwakeningEffect effect) {
        super((OneShotEffect)effect);
    }

    public LifecraftAwakeningEffect copy() {
        return new LifecraftAwakeningEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getTargets().getFirstTarget());
        if (!permanent.isCreature(game) && !permanent.hasSubtype(SubType.VEHICLE, game)) {
            BecomesCreatureTargetEffect continuousEffect = new BecomesCreatureTargetEffect((Token)new LifecraftAwakeningToken(), false, true, Duration.Custom);
            continuousEffect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
            game.addEffect((ContinuousEffect)continuousEffect, source);
            return true;
        }
        return false;
    }
}

