/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.Collection;
import java.util.List;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterCreatureCard;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class LifesFinaleEffect
extends OneShotEffect {
    LifesFinaleEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Destroy all creatures, then search target opponent's library for up to three creature cards and put them into their graveyard. Then that player shuffles";
    }

    private LifesFinaleEffect(LifesFinaleEffect effect) {
        super((OneShotEffect)effect);
    }

    public LifesFinaleEffect copy() {
        return new LifesFinaleEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        List permanents = game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURES, source.getControllerId(), game);
        for (Permanent permanent : permanents) {
            permanent.destroy(source, game, false);
        }
        Player opponent = game.getPlayer(source.getFirstTarget());
        Player player = game.getPlayer(source.getControllerId());
        if (player != null && opponent != null) {
            TargetCardInLibrary target = new TargetCardInLibrary(0, 3, (FilterCard)new FilterCreatureCard("creature cards from their library to put in their graveyard"));
            if (player.searchLibrary(target, source, game, opponent.getId())) {
                player.moveCards((Cards)new CardsImpl((Collection)target.getTargets()), Zone.GRAVEYARD, source, game);
            }
            opponent.shuffleLibrary(source, game);
            return true;
        }
        return false;
    }
}

