/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.UUID;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.common.TargetCreaturePermanent;

public final class LightningDart
extends CardImpl {
    public LightningDart(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.INSTANT}, "{1}{R}");
        this.getSpellAbility().addTarget((Target)new TargetCreaturePermanent());
        this.getSpellAbility().addEffect((Effect)new LightningDartEffect());
    }

    private LightningDart(LightningDart card) {
        super((CardImpl)card);
    }

    public LightningDart copy() {
        return new LightningDart(this);
    }

    static class LightningDartEffect
    extends OneShotEffect {
        public LightningDartEffect() {
            super(Outcome.Damage);
            this.staticText = "{this} deals 1 damage to target creature. If that creature is white or blue, {this} deals 4 damage to it instead";
        }

        private LightningDartEffect(LightningDartEffect effect) {
            super((OneShotEffect)effect);
        }

        public LightningDartEffect copy() {
            return new LightningDartEffect(this);
        }

        public boolean apply(Game game, Ability source) {
            Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
            if (permanent != null) {
                int damage = 1;
                ObjectColor color = permanent.getColor(game);
                if (color.isWhite() || color.isBlue()) {
                    damage = 4;
                }
                permanent.damage(damage, source.getId(), source, game, false, false);
            }
            return false;
        }
    }
}

