/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

class LightningPhoenixWatcher
extends Watcher {
    private final Map<UUID, Integer> damageMap = new HashMap<UUID, Integer>();

    LightningPhoenixWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.DAMAGED_PLAYER) {
            return;
        }
        for (UUID playerId : game.getOpponents(event.getTargetId())) {
            this.damageMap.compute(playerId, (u, i) -> i == null ? event.getAmount() : Integer.sum(i, event.getAmount()));
        }
    }

    public void reset() {
        super.reset();
        this.damageMap.clear();
    }

    boolean checkDamage(UUID playerId) {
        return this.damageMap.getOrDefault(playerId, 0) >= 3;
    }
}

