/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.ActivatedAbilityImpl;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.stack.Spell;

class LightningStormAddCounterEffect
extends OneShotEffect {
    LightningStormAddCounterEffect() {
        super(Outcome.Benefit);
        this.staticText = "Put two charge counters on {this}. You may choose a new target for it.";
    }

    private LightningStormAddCounterEffect(LightningStormAddCounterEffect effect) {
        super((OneShotEffect)effect);
    }

    public LightningStormAddCounterEffect copy() {
        return new LightningStormAddCounterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Spell spell = game.getStack().getSpell(source.getSourceId());
        if (spell != null) {
            spell.addCounters(CounterType.CHARGE.createInstance(2), source.getControllerId(), source, game);
            spell.chooseNewTargets(game, ((ActivatedAbilityImpl)source).getActivatorId(), false, false, null);
            return true;
        }
        return false;
    }
}

