/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.stack.Spell;

class LightningStormCountCondition
implements DynamicValue {
    private final CounterType counter;

    LightningStormCountCondition(CounterType counter) {
        this.counter = counter;
    }

    private LightningStormCountCondition(LightningStormCountCondition countersCount) {
        this.counter = countersCount.counter;
    }

    public int calculate(Game game, Ability sourceAbility, Effect effect) {
        Spell spell = game.getStack().getSpell(sourceAbility.getSourceId());
        if (spell != null) {
            return spell.getCounters(game).getCount(this.counter) + 3;
        }
        return 0;
    }

    public LightningStormCountCondition copy() {
        return new LightningStormCountCondition(this);
    }

    public String toString() {
        return "X";
    }

    public String getMessage() {
        return "3 plus the number of charge counters on it";
    }
}

