/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.Collection;
import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.CardsImpl;
import mage.cards.l.LightstallInquisitorAsThoughEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInHand;

class LightstallInquisitorEffect
extends OneShotEffect {
    public LightstallInquisitorEffect() {
        super(Outcome.Benefit);
        this.staticText = "each opponent exiles a card from their hand and may play that card for as long as it remains exiled. Each spell cast this way costs {1} more to cast. Each land played this way enters tapped.";
    }

    private LightstallInquisitorEffect(LightstallInquisitorEffect effect) {
        super((OneShotEffect)effect);
    }

    public LightstallInquisitorEffect copy() {
        return new LightstallInquisitorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (UUID playerId : game.getOpponents(source.getControllerId())) {
            Player opponent = game.getPlayer(playerId);
            if (opponent == null || opponent.getHand().isEmpty()) continue;
            TargetCardInHand target = new TargetCardInHand();
            opponent.choose(Outcome.Exile, opponent.getHand(), (TargetCard)target, source, game);
            CardsImpl cards = new CardsImpl((Collection)target.getTargets());
            if (cards.isEmpty()) continue;
            opponent.moveCardsToExile(cards.getCards(game), source, game, true, null, "");
            cards.retainZone(Zone.EXILED, game);
            for (Card card : cards.getCards(game)) {
                game.addEffect((ContinuousEffect)new LightstallInquisitorAsThoughEffect(playerId, new MageObjectReference((MageObject)card, game)), source);
            }
        }
        return true;
    }
}

