/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.CardIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledPermanent;

class LilianaDreadhordeGeneralEffect
extends OneShotEffect {
    LilianaDreadhordeGeneralEffect() {
        super(Outcome.Benefit);
        this.staticText = "Each opponent chooses a permanent they control of each permanent type and sacrifices the rest.";
    }

    private LilianaDreadhordeGeneralEffect(LilianaDreadhordeGeneralEffect effect) {
        super((OneShotEffect)effect);
    }

    public LilianaDreadhordeGeneralEffect copy() {
        return new LilianaDreadhordeGeneralEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        FilterPermanent keepFilter = new FilterPermanent();
        keepFilter.add((ObjectSourcePlayerPredicate)TargetController.OPPONENT.getControllerPredicate());
        for (UUID opponentId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player opponent = game.getPlayer(opponentId);
            if (opponent == null || !opponent.hasOpponent(source.getControllerId(), game)) continue;
            for (CardType cardType : CardType.values()) {
                if (!cardType.isPermanentType()) continue;
                FilterControlledPermanent filter = new FilterControlledPermanent("a " + cardType.toString() + " you control (everything you don't choose will be sacrificed)");
                filter.add((Predicate)cardType.getPredicate());
                TargetControlledPermanent target = new TargetControlledPermanent(filter);
                target.withNotTarget(true);
                if (!opponent.choose(this.outcome, (Target)target, source, game)) continue;
                keepFilter.add(Predicates.not((Predicate)new CardIdPredicate(target.getFirstTarget())));
            }
        }
        for (Permanent permanent : game.getBattlefield().getActivePermanents(source.getControllerId(), game)) {
            if (!keepFilter.match(permanent, source.getControllerId(), source, game)) continue;
            permanent.sacrifice(source, game);
        }
        return true;
    }
}

