/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;

class LilianaTheLastHopeEffect
extends OneShotEffect {
    LilianaTheLastHopeEffect() {
        super(Outcome.ReturnToHand);
        this.staticText = ", then you may return a creature card from your graveyard to your hand";
    }

    private LilianaTheLastHopeEffect(LilianaTheLastHopeEffect effect) {
        super((OneShotEffect)effect);
    }

    public LilianaTheLastHopeEffect copy() {
        return new LilianaTheLastHopeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        TargetCardInYourGraveyard target = new TargetCardInYourGraveyard((FilterCard)StaticFilters.FILTER_CARD_CREATURE_YOUR_GRAVEYARD);
        target.withNotTarget(true);
        if (target.canChoose(source.getControllerId(), source, game) && controller.chooseUse(this.outcome, "Return a creature card from your graveyard to hand?", source, game) && controller.choose(Outcome.ReturnToHand, (Target)target, source, game) && (card = game.getCard(target.getFirstTarget())) != null) {
            controller.moveCards(card, Zone.HAND, source, game);
        }
        return true;
    }
}

